/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.taskcontroller;

import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TaskControllerServlet
extends HttpServlet {
    public static final String TRACE_MASK = "HTSKCTL";
    public static final String TRACE_MASKT = "HTSKCTLT";
    public static final String TRACE_MASKF = "HTSKCTLF";
    public static final String TRACE_MASKD = "HTSKCTLD";
    public static final String THIS_CLASS = "TaskControllerServlet";
    public static final String TASK_CONTROLLER_PREFIX = "/js/taskcontroller/";
    public static final String SESSION_LOCK_KEY = "taskController.session.lock";
    public static final String SESSION_LOCK_OWNER_KEY = "taskController.session.lock.owner";
    public static final String THREAD_PREFIX = "TaskControllerServlet ";
    public static final String THREAD_NUMBER_KEY = "taskController.thread.num";
    public static final String WORK_QUEUE_KEY = "taskController.queue";
    public static final String HEARTBEAT_WAIT_KEY = "taskController.heartbeatWait";
    public static final int MAX_BUFFER_SIZE = 65536;
    public static final int DEFAULT_HEARTBEAT_WAIT = 60000;
    public static final String HEARTBEAT_SCRIPT = "<SCRIPT language='JavaScript'>connectedToServer=true;</SCRIPT>";
    public static final String RELOAD_SCRIPT = "<SCRIPT language='JavaScript'>reloadHiddenFrame();</SCRIPT>";
    public static final String FUNCTIONS_SCRIPT = "<SCRIPT language='JavaScript' src='/js/taskcontroller/TCstart.js'></SCRIPT>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        Trace.trace("HTSKCTLF", "--> TaskControllerServlet.doGet:  ");
        session = HMCSession.getHMCSession(request.getSession());
        this.nameThisThread(session);
        Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  thread name is " + Thread.currentThread().getName());
        sessionLock = session.getSessionAttribute("taskController.session.lock");
        if (sessionLock == null) {
            sessionLock = new Object();
            session.setSessionAttribute("taskController.session.lock", sessionLock);
        }
        if ((sessionLockOwner = session.getSessionAttribute("taskController.session.lock.owner")) != null && sessionLockOwner instanceof Thread && !sessionLockOwner.equals(Thread.currentThread())) {
            ((Thread)sessionLockOwner).interrupt();
        }
        disconnectException /* !! */  = null;
        var7_7 = sessionLock;
        synchronized (var7_7) {
            block25: {
                block24: {
                    session.setSessionAttribute("taskController.session.lock.owner", Thread.currentThread());
                    Trace.trace("HTSKCTLF", "TaskControllerServlet.doGet:  got the sessionLock");
                    queue = TaskControllerQueue.getTaskControllerQueue(session);
                    queue.connectToServlet(this);
                    charsSent = 0;
                    script = null;
                    try {
                        block23: {
                            try {
                                response.setContentType("text/html");
                                response.addHeader("Cache-Control", "no-cache");
                                if (request.getProtocol().equals("HTTP/1.0")) {
                                    response.addHeader("Pragma", "no-cache");
                                }
                                if (Thread.currentThread().isInterrupted()) {
                                    Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  exiting, thread interrupted");
                                    var15_11 = null;
                                    break block23;
                                }
                                charsSent = this.writeToClient("<HTML><HEAD><SCRIPT language='JavaScript' src='/js/taskcontroller/TCstart.js'></SCRIPT></HEAD><BODY>", response, charsSent);
                                parm = request.getParameter("errorText");
                                if (parm != null) {
                                    Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  A script sent by the task controller servlet had an error.\nError message:  " + parm);
                                }
                                if ((parm = request.getParameter("reload")) != null) {
                                    Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  The hidden frame is being reloaded.");
                                }
                                var12_25 = queue;
                                synchronized (var12_25) {
                                    queue.resendUpdates();
                                    Trace.trace("HTSKCTLF", "TaskControllerServlet.doGet:  resent any still pending updates on the queue");
                                    block13: while (true) {
                                        if (Thread.currentThread().isInterrupted()) {
                                            Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  exiting, thread interrupted");
                                            // MONITOREXIT @DISABLED, blocks:[1, 2, 5, 21, 6, 13] lbl45 : MonitorExitStatement: MONITOREXIT : var12_25
                                            break block24;
                                        }
                                        script = (String)queue.pull(this.getHeartbeatWait(session));
                                        if (script == null) {
                                            charsSent = this.writeToClient("<SCRIPT language='JavaScript'>connectedToServer=true;</SCRIPT>", response, charsSent);
                                            continue;
                                        }
                                        charsSent = this.writeToClient(script, response, charsSent);
                                        while (true) {
                                            if (queue.size() > 0) ** break;
                                            continue block13;
                                            script = (String)queue.pull();
                                            charsSent = this.writeToClient(script, response, charsSent);
                                        }
                                        break;
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  interrupted, exiting");
                                disconnectException /* !! */  = e;
                                var15_13 = null;
                                session.setSessionAttribute("taskController.session.lock.owner", null);
                                Trace.trace("HTSKCTLF", "<-- TaskControllerServlet.doGet:  exit thread " + Thread.currentThread().getName());
                                queue.disconnectFromServlet(this, disconnectException /* !! */ );
                                break block25;
                            }
                            catch (IndexOutOfBoundsException e) {
                                Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  exiting for reload");
                                disconnectException /* !! */  = e;
                                var15_14 = null;
                                session.setSessionAttribute("taskController.session.lock.owner", null);
                                Trace.trace("HTSKCTLF", "<-- TaskControllerServlet.doGet:  exit thread " + Thread.currentThread().getName());
                                queue.disconnectFromServlet(this, disconnectException /* !! */ );
                                break block25;
                            }
                            catch (IOException e) {
                                Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  exiting, hidden window probably gone");
                                disconnectException /* !! */  = e;
                                var15_15 = null;
                                session.setSessionAttribute("taskController.session.lock.owner", null);
                                Trace.trace("HTSKCTLF", "<-- TaskControllerServlet.doGet:  exit thread " + Thread.currentThread().getName());
                                queue.disconnectFromServlet(this, disconnectException /* !! */ );
                                break block25;
                            }
                            catch (IllegalStateException e) {
                                Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  exiting, session must have ended");
                                disconnectException /* !! */  = e;
                                var15_16 = null;
                                session.setSessionAttribute("taskController.session.lock.owner", null);
                                Trace.trace("HTSKCTLF", "<-- TaskControllerServlet.doGet:  exit thread " + Thread.currentThread().getName());
                                queue.disconnectFromServlet(this, disconnectException /* !! */ );
                                break block25;
                            }
                            catch (Exception e) {
                                Trace.trace("HTSKCTLD", "TaskControllerServlet.doGet:  unexpected exception", e);
                                disconnectException /* !! */  = e;
                                var15_17 = null;
                                session.setSessionAttribute("taskController.session.lock.owner", null);
                                Trace.trace("HTSKCTLF", "<-- TaskControllerServlet.doGet:  exit thread " + Thread.currentThread().getName());
                                queue.disconnectFromServlet(this, disconnectException /* !! */ );
                                break block25;
                            }
                        }
                        session.setSessionAttribute("taskController.session.lock.owner", null);
                    }
                    catch (Throwable var14_26) {
                        var15_18 = null;
                        session.setSessionAttribute("taskController.session.lock.owner", null);
                        Trace.trace("HTSKCTLF", "<-- TaskControllerServlet.doGet:  exit thread " + Thread.currentThread().getName());
                        queue.disconnectFromServlet(this, disconnectException /* !! */ );
                        throw var14_26;
                    }
                    Trace.trace("HTSKCTLF", "<-- TaskControllerServlet.doGet:  exit thread " + Thread.currentThread().getName());
                    queue.disconnectFromServlet(this, disconnectException /* !! */ );
                    return;
                }
                var15_12 = null;
                session.setSessionAttribute("taskController.session.lock.owner", null);
                Trace.trace("HTSKCTLF", "<-- TaskControllerServlet.doGet:  exit thread " + Thread.currentThread().getName());
                queue.disconnectFromServlet(this, disconnectException /* !! */ );
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nameThisThread(HMCSession session) {
        String name;
        ServletContext context;
        ServletContext servletContext = context = this.getServletConfig().getServletContext();
        synchronized (servletContext) {
            Integer threadNum = (Integer)session.getContextAttribute(THREAD_NUMBER_KEY);
            if (threadNum == null) {
                threadNum = new Integer(0);
            }
            int num = threadNum;
            name = THREAD_PREFIX + num + " in session " + session.getSessionId();
            Thread.currentThread().setName(name);
            threadNum = new Integer(num + 1);
            session.setContextAttribute(THREAD_NUMBER_KEY, threadNum);
        }
        return name;
    }

    private int getHeartbeatWait(HMCSession session) {
        Integer heartbeatWait = (Integer)session.getSessionAttribute(HEARTBEAT_WAIT_KEY);
        if (heartbeatWait == null) {
            heartbeatWait = new Integer(60000);
            session.setSessionAttribute(HEARTBEAT_WAIT_KEY, heartbeatWait);
        }
        return heartbeatWait;
    }

    private int writeToClient(String script, HttpServletResponse response, int charsSent) throws IOException, IndexOutOfBoundsException {
        script = "</BODY></HTML>" + script + "<HTML><HEAD></HEAD><BODY>";
        Trace.trace(TRACE_MASKF, "--> TaskControllerServlet.writeToClient:  script=" + script);
        int sent = charsSent + script.length();
        ServletOutputStream out = response.getOutputStream();
        out.print(script);
        Trace.trace(TRACE_MASKD, "TaskControllerServlet.writeToClient:  sent=" + sent);
        if (sent > 65536) {
            Trace.trace(TRACE_MASKD, "TaskControllerServlet.writeToClient:  sending reload script");
            out.print("<SCRIPT language='JavaScript'>reloadHiddenFrame();</SCRIPT></BODY></HTML>");
            out.flush();
            response.flushBuffer();
            throw new IndexOutOfBoundsException();
        }
        out.flush();
        response.flushBuffer();
        Trace.trace(TRACE_MASKF, "<-- TaskControllerServlet.writeToClient:  ");
        return sent;
    }
}

